/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_AUTH_INTERFACE_H
#define _SCE_AUTH_INTERFACE_H

#include "np_toolkit_defines.h"

namespace sce { 
	namespace Toolkit {
	namespace NP {

	/// @brief
	/// The namespace containing PSN authentication functionality.
	///	
	/// The namespace containing PSN authentication functionality.
	namespace Auth {

	/// @brief
	/// External interface to the PSN authentication functionality.
	///	
	/// External interface to the PSN authentication functionality.
	/// This class enables a PSN ticket to be obtained,
	/// which can be passed to an external server in order to authenticate a PSN user.
	class Interface
	{
	public:

		/// @brief 
		/// Retrieves a PSN ticket.
		///
		/// Retrieves a PSN ticket. This can be passed to an external server for authentication.
		/// 
		/// @param ticket		A pointer to the <c>Future</c> object that will hold the ticket.
		///
		/// @retval				SCE_TOOLKIT_NP_SUCCESS					The operation was kicked off successfully.							 
		/// @retval				SCE_TOOLKIT_NP_INVALID_POINTER			An invalid pointer was passed to the <c><i>ticket</i></c> parameter.
		/// @retval				SCE_TOOLKIT_NP_NOT_INITIALISED			The %NP %Toolkit library is not initialized.
		///
		/// @note		
		/// This is an asynchronous function.
		static int getTicket(sce::Toolkit::NP::Utilities::Future<Ticket> *ticket);
	};
			}// end Auth
		}// end NP
	}//end Toolkit
}//end Sce
#endif
